<?php

namespace App\Http\Controllers\Admin;

use App\Console\Commands\Appointment;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\Service;
use App\Models\ServiceFeeStructure;
use App\Models\Slot;
use App\Models\User;
use App\Models\CallMethods;
use App\Models\Appointments;
use App\Models\WorkingHours;
use App\Models\SlotShedule;
use Illuminate\Database\Eloquent\Builder;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use App\Models\PaymentDetails;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use App\Models\PushNotification;
use App\Models\WalletPointCommission;
use App\Models\TherapistCommission;
use \Illuminate\Support\Str;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use App\Models\WalletPoint;
use App\Models\Leave;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\Route;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Support\Facades\Mail;
use App\Mail\BookingMail;

class AppoinmentController extends Controller
{
    public function index(Request $request)
    {
       
        return view('admin.appoinment.add');
    }
    public function saveAppoinment(Request $request)
    {
        $booking_date = str_replace('/', '-', $request->booking_date);
        $booking_date = date("Y-m-d", strtotime($booking_date));
        $dob = str_replace('/', '-', $request->dob);
        $dob = date("Y-m-d", strtotime($dob));

        try {
            if (!isset($request->user)) {
                $name = $request->first_name . ' ' . $request->last_name;
                $slug = SlugService::createSlug(
                    User::class,
                    'slug',
                    $name
                );
                $pn = 'P' . random_int(000000000000000000, 999999999999999999);
                $user = new User();
                $user->Patient_Identification_Number = $pn;
                $user->First_Name = $request->first_name;
                $user->Last_Name = $request->last_name;
                $user->slug = $slug;
                $user->Email = $request->email;
                $user->Phone_Code = $request->code;
                $user->phone = $request->phone;
                $user->Gender = $request->gender;
                $user->DOB = $dob;
                $user->save();
                $user = $user->id;
            } else {
                $user = $request->user;
            }

            $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);

            $lastID = Appointments::orderBy('id', 'DESC')->pluck('id')->first();
            $appointment = new Appointments();
            $appointment->id = $lastID + 1;
            $appointment->Appointment_Type = $request->call_type;
            $appointment->Appointment_Date = $booking_date;
            $appointment->Appointment_Time = $request->slot;
            $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
            $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
            $appointment->therapist_id = $request->therapist;
            $appointment->service_id = $request->service;
            $appointment->slot_id = $request->slot_id;
            $appointment->user_id = $user;
            $appointment->fee = $request->fee;
            $appointment->end_time = date('h:i A', strtotime($closeTime));
            $appointment->context = 'Direct';
            $appointment->payment_status = 'Paid';
            $appointment->invoice_status = 1;
            $appointment->end_datetime =$closeTime;
            $appointment->save();

            $inv_number=Appointments::where('Appointment_Status', '!=','Failed')
            ->orderBy('id','DESC')
            ->pluck('invoice_number')
            ->first();
            Appointments::where('id', $appointment->id)
                ->update(['session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4',
            'invoice_number'=>$inv_number+1]);

            if ($appointment) {
                $therapistname = Therapist::where('id', $request->therapist)->pluck('full_name')->first();

                $user = User::where('id', $user)->first();
                PushNotification::create([
                    'title' => 'Booking Alert',
                    'message' => 'Hi, ' . $user->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . $therapistname . '. Thank you for visting us ',
                    'therapist_notification' => 'You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . $user->First_Name . '. ',
                    'type' => 'Appointment',
                    'user_id' => $user->id,
                    'therapist_id' => $request->therapist,
                    'appoinment_id' =>  $appointment->id
                ]);

                if ($user != NULL) {
                    $data = [
                        "to" => $user->device_token,
                        "notification" => [
                            'title' => 'Yellowcloud Appointment',
                            'body' => 'Hi, ' . $user->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . $therapistname . '. Thank you for visting us ',
                            //      'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". "
                        ],
                        "data" => [
                            "route" => "notification"
                        ]
                    ];

                    sendpushnotification($data);
                }
                $data2 = [
                    "to" => Therapist::where('id', $request->therapist)->pluck('device_token')->first(),
                    "notification" => [
                        'title' => 'Yellowcloud New Appointment',
                        'body' => 'Hi,  You have a new appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . auth()->user()->First_Name,

                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data2);

                $maildata = [
                    "appintment_id" => $appointment->id,
                    "message" => 'Hi, ' . $user->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . $therapistname . '. Thank you for visting us ',
                    "name" => $user->First_Name
                ];
                $email = User::where('id', $request->user)->pluck('Email')->first();
                Mail::to($email)->send(new BookingMail($maildata));

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment is Booked Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function searchTherapist(Request $request)
    {
        if (isset($request->search) || isset($request->provider_category)) {
            $therapist = Therapist::query()
                ->when(
                    $request->search,
                    function (Builder $builder) use ($request) {
                        $builder->where('full_name', 'like', "%{$request->search}%")
                            // ->orWhere('employee_id', 'like', "%{$request->search}%")
                            ->orWhere('designation', 'like', "%{$request->search}%");
                    }
                )
                ->where('provider_category_id', $request->provider_category)
                ->limit(6)
                ->get();
        } else {
            $therapist = Therapist::limit(6)->get();
        }

        $html = '';
        foreach ($therapist as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/therapist/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/male-avatar.jpg');
                } else {
                    $img = asset('assets/img/female-avatar.webp');
                }
            }

            $html .= ' 
            <div class="col-sm-6 col-lg-6 col-xl-6 d-flex" >
                   
                                            <div class="card invoices-grid-card w-100" id="therapist-n-active' . $data->id . '">
                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                    <button class="custom-badge status-gray re-shedule">' . ucfirst($data->designation) . '</button>
                                                </div>
                                                <div class="card-middle">
                                                    <h2 class="card-middle-avatar">
                                                        <a href="javascript:void(0);" class="next_button therapist" data-id="' . $data->id . '">
                                                        <img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->full_name) . '
                                                        </a>
                                                    </h2>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row align-items-center">
                                                        <div class="col">
                                                            <span><i class="fas fa-calendar-alt"></i> Exp: ' . $data->experience . ' yrs</span>

                                                        </div>
                                                        <div class="col-auto">
                                                            <span><i class="fa fa-user-doctor"></i> ' . $data->providerCategory->name . ' </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                  
                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchTherapistForTherapist(Request $request)
    {
        $category_id = Therapist::where('id', $request->therapist_id)->pluck('provider_category_id')->first();
        if (isset($request->service_id) || isset($request->therapist_id)) {
            $therapist = Therapist::query()
                ->when(
                    $request->service_id,
                    function (Builder $builder) use ($request) {
                        $builder->whereJsonContains('services', $request->service_id);
                    }
                )
                ->where('provider_category_id', $category_id)
                ->where('id', '!=', $request->therapist_id)
                ->get();
        } else {
            $therapist = Therapist::get();
        }

        $html = '';
        foreach ($therapist as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/therapist/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/male-avatar.jpg');
                } else {
                    $img = asset('assets/img/female-avatar.webp');
                }
            }

            $html .= ' 
            <div class="col-sm-4 col-lg-4 col-xl-4 d-flex" >
                   
                                            <div class="card invoices-grid-card w-100" id="therapist-n-active' . $data->id . '">
                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                    <button class="custom-badge status-gray re-shedule">' . ucfirst($data->designation) . '</button>
                                                </div>
                                                <div class="card-middle">
                                                    <h2 class="card-middle-avatar">
                                                        <a href="javascript:void(0);" class="next_button therapist" data-id="' . $data->id . '">
                                                        <img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->full_name) . '
                                                        </a>
                                                    </h2>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row align-items-center">
                                                        <div class="col">
                                                            <span><i class="fas fa-calendar-alt"></i> Exp: ' . $data->experience . ' yrs</span>

                                                        </div>
                                                        <div class="col-auto">
                                                            <span><i class="fa fa-user-doctor"></i> ' . $data->providerCategory->name . ' </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                  
                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchUser(Request $request)
    {
        if (isset($request->search) || isset($request->provider_category)) {
            $user = User::query()
                ->when(
                    $request->search,
                    function (Builder $builder) use ($request) {
                        $builder->where('First_Name', 'like', "%{$request->search}%")
                            // ->orWhere('employee_id', 'like', "%{$request->search}%")
                            ->orWhere('Last_Name', 'like', "%{$request->search}%");
                    }
                )
                ->get();
        } else {
            $user = User::limit(6)->get();
        }

        $html = '';
        foreach ($user as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/user/' . $data->image);
            } else {
                if ($data->Gender == 'MALE' || $data->Gender == 'M' || $data->Gender == 'Male') {
                    $img = asset('assets/img/male.png');
                } elseif ($data->Gender == 'FEMALE' || $data->Gender == 'F' || $data->Gender == 'Female') {
                    $img = asset('assets/img/female.png');
                } else {
                    $img = asset('assets/img/other.png');
                }
            }
            $html .= ' 
             <div class="next_button col-sm-6 col-lg-6 col-xl-6 d-flex">
                                                        <!-- <a href="#" class="user_div" data-id="' . $data->id . '"> -->
                                                        <div class="card invoices-grid-card w-100">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <button class="custom-badge status-gray re-shedule">' . $data->Patient_Identification_Number . '</button>
                                                            </div>
                                                            <div class="card-middle">
                                                                <h2 class="card-middle-avatar">
                                                                    <a href="javascript:void(0);" class="user_div" data-id="' . $data->id . '"><img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->First_Name) . ' ' . ucfirst($data->Last_Name) . '
                                                                    </a>
                                                                </h2>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row align-items-center">
                                                                    <div class="col">
                                                                        <span><img src="' . asset('assets/img/icons/menu-icon-09.svg') . '" alt=""> ₹500</span>

                                                                    </div>
                                                                    <div class=" col-auto">
                                                                        <span><i class="fa fa-phone"></i> ' . $data->phone . '</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- </a> -->

                                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchTherapistService(Request $request)
    {
        $html = '';
        if (isset($request->id)) {
            $therapist = Therapist::select('id', 'services')->where('id', $request->id)
                ->first();
        } else {
            $html .= "Please select a therapist";
        }


        foreach ($therapist->services as $item) {
            $data = Service::where('id', $item)->first();
            if ($data->image != NULL) {
                $img = asset('assets/uploads/service/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/no-image-available.jpg');
                } else {
                    $img = asset('assets/img/no-image-available.jpg');
                }
            }


            $html .= '     <div class="next_button col-sm-6 col-lg-6 col-xl-4 d-flex">
                                    <a href="javascript:void(0);" class="service" data-id="' . $data->id . '">
                                        <div class="card invoices-grid-card w-100">
                                            <div class="card wallet-widget">
                                                <div class="circle-bar circle-bar2">
                                                    <div class="circle-graph2" data-percent="66"><canvas width="400" height="400"></canvas>
                                                        <b><img src="' . $img . '" class="avatar avatar-sm me-2 avatar-img rounded-circle" alt=""></b>
                                                    </div>
                                                </div>
                                                <div class="main-limit">
                                                    <h4>' . $data->service_name . '</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>
                                ';
        }

        return  response()->json($html);
    }

    public function searchServiceMethods(Request $request)
    {
        $html = '';
        $therapist = Therapist::where('id', $request->therapist)
            ->first();

        $data = ServiceFeeStructure::where('service_id', $request->id)->where('provider_category_id', $therapist->provider_category_id)->get();

        foreach ($data as $key => $item) {
            $call_methods[$key] = [
                'id' => $item->callMethod->id,
                'name' => $item->callMethod->name,
                'fee' => $item->rate
            ];
        }

        //$item = collect($call_methods)->unique()->values();


        foreach ($call_methods as $data) {
            if ($data['name'] == 'Video') {
                $icon = 'video';
            } elseif ($data['name'] == 'Audio') {
                $icon = 'phone-volume';
            } elseif ($data['name'] == 'Chat') {
                $icon = 'comment';
            }
            $html .= ' <div class="next_button col-sm-6 col-lg-6 col-xl-4 d-flex">
                                    <a href="javascript:void(0);" class="callmethod"  data-id="' . $data['id'] . '"   data-value="' . $data['fee'] . '" >
                                        <div class="card invoices-grid-card w-100">
                                            <div class="card wallet-widget">
                                            <div class="circle-bar circle-bar2">
                                                    <div class="circle-graph2" data-percent="66"><canvas width="400" height="400"></canvas>
                                                        <b><i class="fas fa-' . $icon . '"></i></b>
                                                    </div>
                                                </div>
                                                <div class="main-limit">
                                                    <h4>' . $data['name'] . '</h4>
                                                    <h3 style="padding-top: 10px;
    font-size: 20px;"><span class="negative-view">₹' . $data['fee'] . '</span> </h3>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>';
        }
        return  response()->json($html);
    }

    public function searchSlot(Request $request)
    {
        $html = '';

        $current_date = date("Y-m-d");
        $current_time = date("H:i");
        $booking_date = str_replace('/', '-', $request->bookingDate);
        $booking_date = date("Y-m-d", strtotime($booking_date));
        $error = '   <p class="text-center"><b>No slots Found</b></p>';
        $day = Carbon::createFromFormat('d/m/Y', $request->bookingDate)->format('l');
        $service = $request->service;
        $leaves = Leave::where('therapist_id', $request->therapist)
            ->where('leave_from', '<=', $booking_date)
            ->where('leave_to', '>=', $booking_date)
            ->first();

        if ($leaves == null) {
            $slot = Slot::where('therapist_id', $request->therapist)->first();
            if ($slot) {
                $html .= '   
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Available time slots</th>
                                            </tr>
                                        </thead>
                                        <tbody>';
                $html .= '<tr> <td>';
                $therapist_workinghours = WorkingHours::where('slot_id', $slot->id)
                    ->where('day', $day)
                    //  ->where('service_id', $service)
                    ->get();



                if (!empty($therapist_workinghours)) {
                    $i = 0;
                    $j = 0;
                    foreach ($therapist_workinghours as $workinghours) {
                        $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $request->callmethod)->first();

                        if ($slotlist) {
                            foreach (json_decode($slotlist->slots) as $sk => $x) {
                                    if($request->user_id){
                                       $booked = Appointments::where('Appointment_Date', $booking_date)
                                                                    ->where('user_id','!=',$request->user_id)
                                                                    ->where('slot_id', $slotlist->id)
                                                                    ->where('Appointment_Time', $x)
                                                                    ->first();
                                                           
                                    }else{
                                        $booked = Appointments::where('slot_id', $slotlist->id)
                                        ->where('Appointment_Time', $x)
                                        ->where('Appointment_Date', $booking_date)
                                        ->first();
                                           
                                    }

                                $color = '';
                                $title = '';
                                $disabled = '';
                                $slot_flag = 0;
                                //***** */

                                if($request->user_id){
                                $bookedslots = Appointments::where('user_id','!=',$request->user_id)                        
                                ->where('Appointment_Date', $booking_date)
                                ->get();
                              
                                }else{
                                    $bookedslots = Appointments::where('therapist_id', $request->therapist)
                                    ->where('Appointment_Date', $booking_date)
                                    ->get();
                                    
                                }

                                if ($bookedslots) {
                                    foreach ($bookedslots as $bookedslot) {
                                        $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();
                                        $flag = 0;
                                        $next_booked_slot = '';
                                        $prev_slot = '';
                                        $prev = '';
                                        if ($booked_slotlist) {
                                            foreach (json_decode($booked_slotlist->slots) as $k => $bs) {

                                                if ($bookedslot->Appointment_Time == $bs) {
                                                $flag = 1;
                                                    continue;
                                                } else {
                                                    if ($flag == 1) {
                                                        $prev = $prev_slot;
                                                        $next_booked_slot = $bs;
                                                        break;
                                                    }
                                                }
                                                $prev_slot = $bs;
                                            }

                                            $prev = $prev_slot;

                                       $time1  = date("H:i", strtotime($bookedslot->Appointment_Time));
                                            $time2 = date("H:i", strtotime($bookedslot->end_time));
                                            // $time2 = date("H:i", strtotime($next_booked_slot)));
                                            // $time3 = date("H:i", strtotime($prev));
                                     $checkedtime = date("H:i", strtotime($x));
                                            if ($checkedtime >= $time1 && $checkedtime <= $time2) {
                                                //   if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {
                                        echo        $slot_flag = 1;die();
                                                break;
                                            }
                                        }
                                    }
                                }

                                if ($slot_flag == 1) {

                                    continue;
                                }

                                if ($booked) {

                                    if ($booked->Appointment_Status == 'Awaiting') {
                                        $color = 'orange';
                                        $title = 'Awaiting';
                                        $disabled = 'disabled';
                                    } elseif ($booked->Appointment_Status == 'Completed') {
                                        $color = 'green';
                                        $title = 'Completed';
                                        $disabled = 'disabled';
                                    } elseif ($booked->Appointment_Status == 'Concluded') {
                                        $color = 'blue';
                                        $title = 'Concluded';
                                        $disabled = 'disabled';
                                    } elseif ($booked->Appointment_Status == 'Rejected') {
                                        $color = 'pink';
                                        $title = 'Rejected';
                                        $disabled = 'disabled';
                                    }
                                }
                                $givenDateTime = date("H:i", strtotime($x));


                                if ($current_date == $booking_date) {

                                    if ($current_time < $givenDateTime) {

                                        $html .= ' <button class="custom-badge status-' . $color . ' slot-btn"  data-id="' . $slotlist->id . '" title="' . $title . '" data-value="' . $x . '"  "' . $disabled . '">' . $x . '</button>';
                                    }
                                } else {

                                    $html .= ' <button class="custom-badge status-' . $color . ' slot-btn"  data-id="' . $slotlist->id . '" title="' . $title . '" data-value="' . $x . '"  "' . $disabled . '">' . $x . '</button>';
                                }
                                //*** */


                            }
                        } else {
                            $html .= $error;
                        }
                    }
                } else {

                    $html .= ' </td>  </tr>';

                    $html .= '      </tbody>
                                    </table>
                                ';
                    $html .= $error;
                }
            } else {
                $html .= $error;
            }
        } else {
            $error = '<p class="text-center"><b>Therapist on Leave</b></p>';
            $html .= $error;
        }
        return  response()->json($html);
    }

    public function paymentSummary(Request $request)
    {
        // print_r($request->all());     
        $html = '';
        $therapist = Therapist::select('id', 'full_name')->where('id', $request->therapist)->first();
        $service = Service::select('id', 'service_name')->where('id', $request->service)->first();

        $html = '<div class="invoice-total-card">
                                                    <div class="invoice-total-box">
                                                        <div class="invoice-total-inner">
                                                            <p>Therapist <span>' . $therapist->full_name . '</span></p>
                                                            <p>Date <span>' . $request->bookingDate . '</span></p>
                                                            <p>Time <span>' . $request->slot . '</span></p>
                                                            <div class="invoice-total-footer">
                                                                <p><b>Service</b></p>
                                                                <p class="mb-0">' . $service->service_name . ' : ₹' . $request->fee . '</p>
                                                            </div>
                                                        </div>
                                                        <div class="invoice-total-footer">
                                                            <h4>Total Amount <span>₹' . $request->fee . '</span></h4>
                                                        </div>
                                                    </div>
                                                </div>';

        return  response()->json($html);
    }

    public function getAppoinments(Request $request)
    {
        if ($request->ajax()) {
            $data = Appointments::orderBy('id', 'DESC')->get();

            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('Appointment_Date', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            if ($request->filled('status')) {
                $data = $data->where('Appointment_Status', $request->status);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('slno', function ($data) {
                    return $data->id;
                })
                ->addColumn('session_id', function ($data) {
                    return '<a href="' . route('admin.view-appoinment', ['id' => $data->id]) . '">' . $data->session_id . ' </a>';
                })
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data->id]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                 <a href="' . route('admin.invoice', ['id' => $data->id]) . '"  target="_blank"  class="text-muted"> <span class="badge badge-success" target="_blank"><i class="fa fa-file-invoice"></i></span></a>
                    <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('service', function ($data) {
                    return $data->service->service_name;
                })

                ->addColumn('username', function ($data) {

                    if (empty($data->user)) {
                        $img = asset('assets/img/male-avatar.jpg');
                        $name = "USER";
                    } else {
                        if ($data->user->image != NULL) {
                            $img = asset('assets/uploads/user/' . $data->user->image);
                            $name = $data->user->First_Name . $data->user->Last_Name;
                        } else {
                            $name = $data->user->First_Name;
                            if ($data->user->Gender == 'MALE' || $data->user->Gender == 'M') {
                                $img = asset('assets/img/male.png');
                            } elseif ($data->user->Gender == 'FEMALE' || $data->user->Gender == 'F') {
                                $img = asset('assets/img/female.png');
                            } else {
                                $img = asset('assets/img/other.png');
                            }
                        }
                    }
                    $html = '<div class=" d-flex align-items-center">
                                <div class="img-users call-user">
                                <a href=""><img src="' . $img . '" alt="img"></a>
                                </div>
                                <div class="chat-users">
                                <div class="user-titles d-flex">
                                <h5>' . $name  . ' </h5>
                                </div>
                                </div>
                                </div>';

                    return   $html;
                })

                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                        $img = asset('assets/uploads/therapist/' . $data->therapist->image);
                    } else {
                        $name = "USER NOT fOUND";
                        if ($data->therapist->gender == 'MALE') {
                            $img = asset('assets/img/male-avatar.jpg');
                        } else {
                            $img = asset('assets/img/female-avatar.webp');
                        }
                    }
                    $html = '<div class=" d-flex align-items-center">
                        <div class="img-users call-user">
                        <a href="' . route('admin.view-therapist', ['slug' => $data->therapist->slug]) . '"><img src="' . $img . '" alt="img"></a>
                        </div>
                        <div class="chat-users">
                        <div class="user-titles d-flex">
                        <h5>' . $name . ' </h5>
                        </div>
                        <div class="user-text d-flex">
                        <p>' . $data->therapist->professional_credentials . '</p>
                        </div>
                        </div>
                        </div>';

                    return   $html;
                })


                ->addColumn('status', function ($data) {
                    $color = statusColor($data->Appointment_Status);
                    return '<button class="btn" style="background:' . $color . ';font-size: 12px;
    padding: 4px;font-weight:600;">' . $data->Appointment_Status . '</button>';
                })
                ->addColumn('date_and_time', function ($data) {
                    $html = "<p> Date:" . date('d M Y', strtotime($data->Appointment_Date));
                    $html .= " Time:" . $data->Appointment_Time . '</p>';
                    return $html;
                })
                ->addColumn('payment_id', function ($data) {
                    $id = PaymentDetails::where('id', $data->payment_id)->pluck('payment_id')->first();
                    return $id;
                })
                ->addColumn('communication_type', function ($data) {
                    $type = CallMethods::where('id', $data->Appointment_Type)->pluck('name')->first();
                    return $type;
                })
                ->addColumn('context', function ($data) {
                    return $data->context;
                })
                ->addColumn('fee', function ($data) {
                    return $data->fee;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function viewAppoinment(Request $request)
    {

        $data = Appointments::where('id', $request->id)->first();
        return view('admin.appoinment.view', compact('data'));
    }
    public function transferAppoinments(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        return view('admin.appoinment.transfer', compact('data'));
    }
    public function bookUserAppoinments(Request $request)
    {

        return view('admin.appoinment.book-user-appointment', ['user_id' => $request->id]);
    }
    public function deleteAppoinment(Request $request)
    {
        $data = Appointments::where('id', $request->id)->delete();
        return $data;
    }

    public function previousAppoinments(Request $request)
    {
        if ($request->ajax()) {
            // ****** previuos appoinments *************

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            //    $array = Appointments::where('user_id', $request->slug)->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            $array = Appointments::where('user_id', $request->slug)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->orWhere('Appointment_Status', '!=', 'Join')
                ->orWhere('Appointment_Status', '!=', 'No Participants')
                ->orWhere('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {

                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();

                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";

                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_slug'] = $item->therapist->slug;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {

                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_slug'] = $item->therapist->slug;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;

                    $key++;
                }
            }

            // ********** previuos appoinment end **************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-therapist', ['slug' => $data['therapist_slug']]) . '"><img width="28" height="28" src="' . $data['therapist_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['therapist_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function upcomingAppoinments(Request $request)
    {
        if ($request->ajax()) {

            // *********** Upcoming Appoinment ***********************
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            //     $array = Appointments::where('user_id', $request->slug)->where('Appointment_Date', '>=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            $array = Appointments::where('user_id', $request->slug)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Date', '>=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();

            foreach ($array as $item) {
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_slug'] = $item->therapist->slug;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_slug'] = $item->therapist->slug;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }

            // *********** Upcoming Appoinment end ***********************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-therapist', ['slug' => $data['therapist_slug']]) . '"><img width="28" height="28" src="' . $data['therapist_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['therapist_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    // **** therapist appoinments ****************

    public function previousAppoinmentsTherapist(Request $request)
    {
        if ($request->ajax()) {
            // ****** previuos appoinments *************

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', $request->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Join')
                ->where('Appointment_Status', '!=', 'No Participants')
                ->where('Appointment_Date', '<=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();

            foreach ($array as $item) {
                if ($item->user->image != NULL) {
                    $img = asset('assets/uploads/user/' . $item->user->image);
                } else {
                    if ($item->user->Gender == 'MALE' || $item->user->Gender == 'M') {
                        $img = asset('assets/img/male.png');
                    } elseif ($item->user->Gender == 'FEMALE' || $item->user->Gender == 'F') {
                        $img = asset('assets/img/female.png');
                    } else {
                        $img = asset('assets/img/other.png');
                    }
                }

                //  $duration = Slot::where('therapist_id', $request->id)->pluck('call_duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                // $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time < $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['user_slug'] = $item->user->slug;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['fee'] =  $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_id'] = $item->user->id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = $img;
                    $data[$key]['user_slug'] = $item->user->slug;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_status'] = $item->call_status;
                    $data[$key]['fee'] =  $item->fee;
                    $key++;
                }
            }
            // ********** previuos appoinment end **************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href=""><img width="28" height="28" src="' . $data['user_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['user_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function upcomingAppoinmentsTherapist(Request $request)
    {
        if ($request->ajax()) {

            // *********** Upcoming Appoinment ***********************
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;

            $array = Appointments::where('therapist_id', $request->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Date', '>=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                // $closeTime =  Carbon::parse($time)->addMinutes($duration);
                if ($item->user->image != NULL) {
                    $img = asset('assets/uploads/user/' . $item->user->image);
                } else {
                    if ($item->user->Gender == 'MALE' || $item->user->Gender == 'M') {
                        $img = asset('assets/img/male.png');
                    } elseif ($item->user->Gender == 'FEMALE' || $item->user->Gender == 'F') {
                        $img = asset('assets/img/female.png');
                    } else {
                        $img = asset('assets/img/other.png');
                    }
                }
                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        } else {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_id'] = $item->user->id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = $img;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_status'] = $item->call_status;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }
            // *********** Upcoming Appoinment end ***********************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href=""><img width="28" height="28" src="' . $data['user_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['user_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })

                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    // **** end therapist appoinments ****************

    public function changeAppoinmentStatus(Request $request)
    {

        $res = Appointments::where('id', $request->id)
            ->update(['Appointment_Status' => $request->status]);

        if ($request->status == 'Completed') {

            $appoinment = Appointments::select('fee', 'therapist_id')->where('id', $request->id)->first();

            $commission = TherapistCommission::where('therapist_id', $appoinment->therapist_id)->where('appoinment_id', $request->id)->first();


            if ($commission == null) {
                $providercategory = Therapist::where('id', $appoinment->therapist_id)->pluck('provider_category_id')->first();

                $platformFeePercentage = WalletPointCommission::where('provider_category_id', $providercategory)->pluck('commission')->first();
                $amount = $appoinment->fee;
                $platformFee = $amount * ($platformFeePercentage / 100);
                $therapistEarnings = $amount - $platformFee;

                $tc = new TherapistCommission();
                $tc->therapist_id = $appoinment->therapist_id;
                $tc->appoinment_id = $request->id;
                $tc->amount = $amount;
                $tc->commission = $platformFeePercentage;
                $tc->platform_fee = $therapistEarnings;
                $tc->therapist_earnings =  $platformFee;
                $tc->save();
            }
        }
        if ($request->status == 'Rejected') {

            $item = Appointments::where('id', $request->id)->first();
            if ($item->user->device_token != NULL) {
                PushNotification::create([
                    'title' => ' Appoinment' . $request->status,
                    'therapist_notification' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . " by Admin.",
                    'message' => "Hi, your appointment on yellowcloud   on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status,
                    'type' => 'Status',
                    'user_id' => $item->user->id,
                    'therapist_id' => $item->therapist->id,
                    'appoinment_id' => $item->id
                ]);

                $data = [
                    "to" => $item->user->device_token,
                    "notification" => [
                        'title' => ' Appoinment' . $request->status,
                        'body' => "Hi, your appointment on yellowcloud   on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data);
                $data1 = [
                    "to" => $item->therapist->device_token,
                    "notification" => [
                        'title' => ' Appoinment' . $request->status,
                        'body' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . " by Admin."
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data1);
            }
        }
        if ($request->status == 'Cancel' || $request->status == 'Confirm') {

            $item = Appointments::where('id', $request->id)->first();

            if ($res == 1 && $request->status == 'Cancel') {

                $point = WalletPoint::orderBy('id', 'DESC')->first();

                $amount = Appointments::where('id', $request->id)->pluck('fee')->first();
                $userpoint = $amount;


                $userwallet = UserWallet::where('user_id',  $item->user_id)->first();

                if ($userwallet == null) {
                    $userBalance = 0;

                    $balance = $userBalance + $userpoint;

                    $userwalletadd = new UserWallet();
                    $userwalletadd->user_id = $item->user_id;
                    $userwalletadd->balance = $balance;
                    $userwalletadd->save();
                } else {
                    $userBalance = $userwallet->balance;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                        'user_id' => $item->user_id,
                        'balance' => $balance
                    ]);
                }

                $userWalletTransaction = new UserWalletTransactions();
                $userWalletTransaction->user_id = $item->user_id;
                $userWalletTransaction->wallet_id = 2;
                $userWalletTransaction->type = 'Credit';
                $userWalletTransaction->amount = $amount;
                $userWalletTransaction->point = $userpoint;
                $userWalletTransaction->current_balance = $balance;
                $userWalletTransaction->save();
            }

            if ($item->user->device_token != NULL) {
                PushNotification::create([
                    'title' => $request->status . ' Appoinment',
                    'therapist_notification' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . "ed by Admin.",
                    'message' => "Hi, your appointment on yellowcloud   on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . "ed.",
                    'type' => 'Status',
                    'user_id' => $item->user->id,
                    'therapist_id' => $item->therapist->id,
                    'appoinment_id' => $item->id
                ]);

                $data = [
                    "to" => $item->user->device_token,
                    "notification" => [
                        'title' => $request->status . ' Appoinment',
                        'body' => "Hi, your appointment on yellowcloud   on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . "ed."
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data);
                $data1 = [
                    "to" => $item->therapist->device_token,
                    "notification" => [
                        'title' => $request->status . ' Appoinment',
                        'body' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been " . $request->status . "ed by Admin."
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data1);
            }
        } elseif ($request->status == 'Resheduled') {
            $item = Appointments::where('id', $request->id)->first();

            if ($item->user->device_token != NULL) {
                PushNotification::create([
                    'title' => 'Resheduled Appoinment',
                    'therapist_notification' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " has been Resheduled on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " .",
                    'message' => "Hi, " . $item->user->First_Name . "  " . $item->user->Last_Name . " your appointment on yellowcloud  with " . $item->therapist->prefix . " " . $item->therapist->full_name . " has been Resheduled on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " .",
                    'type' => 'C',
                    'appoinment_id' => $item->id
                ]);

                $data = [
                    "to" => $item->device_token,
                    "notification" => [
                        'title' => 'Resheduled Appoinment',
                        'body' => "Hi, " . $item->user->First_Name . "  " . $item->user->Last_Name . " your appointment on yellowcloud  with " . $item->therapist->prefix . " " . $item->therapist->full_name . " has been Resheduled on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " ."
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data);

                $data1 = [
                    "to" => $item->device_token,
                    "notification" => [
                        'title' => 'Resheduled Appoinment',
                        'body' => "Hi,  your appointment on yellowcloud  with " . $item->user->First_Name . "  " . $item->user->Last_Name . " has been Resheduled on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " ."
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data1);
            }
        }
        return $res;
    }

    public function resheduleAppoinment(Request $request)
    {

        try {
            $booking_date = str_replace('/', '-', $request->booking_date);
            $booking_date = date("Y-m-d", strtotime($booking_date));
            $therapist = Appointments::where('id', $request->appoinment_id)->pluck('therapist_id')->first();
            $duration = Slot::where('therapist_id', $therapist)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);


            $res = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => $booking_date,
                'Appointment_Time' => $request->slot,
                'Appointment_Status' => 'Resheduled',
                'slot_id' => $request->slot_id,
                'end_time' => date('h:i A', strtotime($closeTime))
            ]);
            if ($res == 1) {
                return back()->with('success', "Your Appointment resheduled Sucessfully");
            } else {
                return back()->with('error', "Something went Wrong");
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function saveTransferAppoinments(Request $request)
    {

        try {
            $booking_date = str_replace('/', '-', $request->booking_date);
            $booking_date = date("Y-m-d", strtotime($booking_date));

            $res = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => $booking_date,
                'Appointment_Time' => $request->slot,
                'therapist_id' => $request->therapist_id,
                'slot_id' => $request->slot_id
            ]);
            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'msg' => "Appointment transferred Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'msg' => "Something went Wrong"
                    ),
                    200
                );
            }

            // if ($res == 1) {
            //     return back()->with('success', "Appointment transferred Sucessfully");
            // } else {
            //     return back()->with('error', "Something went Wrong");
            // }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function addPrescription(Request $request)
    {
        try {

            $image = NULL;
            if ($request->hasFile('attachment')) {
                if ($request->id) {
                    $exist = Prescription::where('id', $request->id)->first();
                    if (file_exists(public_path('assets/uploads/prescription/' . $exist->attachment)) && ($exist->attachment != null)) {
                        unlink("assets/uploads/prescription/" . $exist->attachment);
                    }
                }
                $rand = rand(100, 999);
                $image = time() . '.' . $request->attachment->extension();
                $imageOriginalName = $request->attachment->getClientOriginalName();
                $request->attachment->move(public_path('assets/uploads/prescription'), $image);
            }
            if ($request->id) {
                $review = Prescription::where('id', $request->id)->update([
                    'therapist_id' => $request->therapist_id,
                    'attachment' => $image
                ]);
            } else {
                $review = new Prescription();
                $review->therapist_id = $request->therapist_id;
                $review->user_id = $request->user_id;
                $review->appoinment_id = $request->appoinment_id;
                $review->attachment = $image;
                $review->save();
            }


            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Prescription added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addConsulation(Request $request)
    {
        try {
            if ($request->id) {
                $exist = ConsulationNote::where('id', $request->id)->first();
            }
            $image = NULL;
            if ($request->hasFile('attachment')) {
                if ($request->id) {
                    if (file_exists(public_path('assets/uploads/consultation/' . $exist->attachment)) && ($exist->attachment != null)) {
                        unlink("assets/uploads/consultation/" . $exist->attachment);
                    }
                }
                $rand = rand(100, 999);
                $image = time() . '.' . $request->attachment->extension();
                $imageOriginalName = $request->attachment->getClientOriginalName();
                $request->attachment->move(public_path('assets/uploads/consultation'), $image);
            }
            if ($request->id) {
                $res = ConsulationNote::where('id', $request->id)
                    ->update([
                        'user_id' => $request->user_id,
                        'appoinment_id' => $request->appoinment_id,
                        'note' => $request->note,
                        'attachment' => $image
                    ]);
            } else {
                $res = new ConsulationNote();
                $res->therapist_id = $request->therapist_id;
                $res->user_id = $request->user_id;
                $res->appoinment_id = $request->appoinment_id;
                $res->note = $request->note;
                $res->attachment = $image;
                $res->save();
            }
            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Consulation added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function downloadConsultationNote(Request $request)
    {
        $data = ConsulationNote::where('id', $request->id)->first();
        $age = Carbon::parse($data->user->DOB)->age;
        $name = "eConsultation_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        return view('admin.pdf.consulation-pdf', ['data' => $data, 'age' => $age, 'name' => $name]);
    }
    public function downloadPrescriptionNote(Request $request)
    {
        $data = Prescription::where('id', $request->id)->first();
        $age = Carbon::parse($data->user->DOB)->age;
        $name = "ePrescription_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        return view('admin.pdf.prescription-pdf', ['data' => $data, 'age' => $age, 'name' => $name]);
    }
    public function invoice(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        $name = "eBill_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        // $pdf = PDF::loadView('admin.pdf.invoice', ['data' => $data, 'name' => $name]);
        // return $pdf->download('document.pdf');
        return view('admin.pdf.invoice', ['data' => $data, 'name' => $name]);
    }
    public function downloadInvoice(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        $name = "eBill_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        // $pdf = PDF::loadView('admin.pdf.invoice', ['data' => $data, 'name' => $name]);
        // return $pdf->download('document.pdf');
        return view('admin.pdf.invoice-mail', ['data' => $data, 'name' => $name]);
    }
}
